<?php
session_start(); // Inicia a sessão

// Verifica se o usuário está logado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    // Redireciona para a página de login se não estiver logado
    header('Location: login.html?message=' . urlencode('Acesso restrito. Faça login.') . '&type=error');
    exit();
}

// Configurações do banco de dados (as mesmas do seu processa_login.php)
$host = 'localhost';
$db = 'infroshop_banner';
$user = 'infroshop_user';
$pass = 'edlKU2y3bO?d';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    // Em caso de erro de conexão, você pode exibir uma mensagem ou redirecionar
    // (Apenas para depuração, em produção é melhor não expor o erro)
    // die('Erro de conexão com o banco de dados: ' . $e->getMessage());
    header('Location: login.html?message=' . urlencode('Erro de conexão com o banco de dados. Tente novamente mais tarde.') . '&type=error');
    exit();
}

// Captura mensagens da URL (após redirecionamento de outras páginas)
$message_text = '';
$message_type = '';
if (isset($_GET['message']) && isset($_GET['type'])) {
    $message_text = htmlspecialchars(urldecode($_GET['message']));
    $message_type = htmlspecialchars($_GET['type']);
}

?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Gerador de Banner Moderno</title>
  <meta name="description" content="Gere banners incríveis de filmes e séries em poucos cliques. Visual moderno, responsivo e rápido.">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet" />
  <style>
    html { scroll-behavior: smooth; }
    
    /* Estilos globais */
:root {
    --primary-blue: #0066ff;
    --secondary-blue: #1e40af;
    --accent-blue: #3b82f6;
    --light-blue: #60a5fa;
    --dark-blue: #1e3a8a;
    --cyan: #06b6d4;
    --bg-dark: #0f1419;
    --bg-card: #1a1f2e;
    --bg-glass: rgba(26, 31, 46, 0.85);
    --text-primary: #ffffff;
    --text-secondary: #94a3b8;
    --shadow-primary: 0 8px 32px rgba(0, 102, 255, 0.25);
    --shadow-glow: 0 0 40px rgba(0, 102, 255, 0.4);
    --gradient-primary: linear-gradient(135deg, var(--primary-blue) 0%, var(--cyan) 100%);
    --gradient-bg: linear-gradient(135deg, #0f1419 0%, #1e3a8a 100%);
    --radius: 24px;
    --radius-sm: 16px;
}

/* Light theme variables */
body.light-theme {
    --bg-dark: #f8fafc;
    --bg-card: #ffffff;
    --bg-glass: rgba(255, 255, 255, 0.85);
    --text-primary: #1e293b;
    --text-secondary: #64748b;
    --gradient-bg: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    --shadow-primary: 0 8px 32px rgba(0, 102, 255, 0.15);
}

html {
    scroll-behavior: smooth;
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
    background: var(--gradient-bg);
    color: var(--text-primary);
    min-height: 100vh;
    overflow-x: hidden;
    position: relative;
    transition: all 0.3s ease;
    display: flex; /* Adicionado para o layout com sidebar */
}

/* Animated background particles */
.bg-animation {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    z-index: 0;
    overflow: hidden;
}

.particle {
    position: absolute;
    background: var(--primary-blue);
    border-radius: 50%;
    animation: float 6s ease-in-out infinite;
    opacity: 0.1;
}

.particle:nth-child(1) {
    width: 8px;
    height: 8px;
    top: 20%;
    left: 10%;
    animation-delay: 0s;
}

.particle:nth-child(2) {
    width: 12px;
    height: 12px;
    top: 60%;
    left: 80%;
    animation-delay: 2s;
}

.particle:nth-child(3) {
    width: 6px;
    height: 6px;
    top: 40%;
    left: 60%;
    animation-delay: 4s;
}

.particle:nth-child(4) {
    width: 10px;
    height: 10px;
    top: 80%;
    left: 20%;
    animation-delay: 1s;
}

.particle:nth-child(5) {
    width: 14px;
    height: 14px;
    top: 30%;
    left: 90%;
    animation-delay: 3s;
}

@keyframes float {
    0%, 100% {
        transform: translateY(0px) rotate(0deg);
    }
    33% {
        transform: translateY(-20px) rotate(120deg);
    }
    66% {
        transform: translateY(10px) rotate(240deg);
    }
}

/* Theme toggle */
.toggle-theme {
    position: fixed;
    top: 24px;
    right: 24px;
    background: var(--bg-glass);
    border: 2px solid var(--primary-blue);
    border-radius: 50%;
    width: 56px;
    height: 56px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    backdrop-filter: blur(20px);
    z-index: 2000;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: var(--shadow-primary);
}

.toggle-theme:hover {
    transform: scale(1.1);
    box-shadow: var(--shadow-glow);
    border-color: var(--cyan);
}

.toggle-theme svg {
    width: 28px;
    height: 28px;
    stroke: var(--primary-blue);
    fill: none;
    transition: all 0.3s ease;
}

/* Main container */
.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 2rem;
    position: relative;
    z-index: 10;
}

/* Header section */
.header-section {
    text-align: center;
    margin-bottom: 4rem;
    padding: 3rem 0;
}

.main-title {
    font-size: clamp(2.5rem, 8vw, 4.5rem);
    font-weight: 900;
    background: var(--gradient-primary);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    margin-bottom: 1rem;
    letter-spacing: -0.02em;
    line-height: 1.1;
    animation: titleGlow 3s ease-in-out infinite alternate;
}

@keyframes titleGlow {
    from {
        filter: drop-shadow(0 0 20px rgba(0, 102, 255, 0.3));
    }
    to {
        filter: drop-shadow(0 0 40px rgba(6, 182, 212, 0.5));
    }
}

.subtitle {
    font-size: 1.25rem;
    color: var(--text-secondary);
    font-weight: 400;
    max-width: 600px;
    margin: 0 auto 2rem auto;
    line-height: 1.6;
}

/* Search section */
.search-section {
    background: var(--bg-glass);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(59, 130, 246, 0.3);
    border-radius: var(--radius);
    padding: 2.5rem;
    margin-bottom: 3rem;
    box-shadow: var(--shadow-primary);
    position: relative;
    overflow: hidden;
    animation: slideUp 0.8s ease-out;
}

.search-section::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 2px;
    background: var(--gradient-primary);
    animation: shimmer 2s infinite;
}

@keyframes shimmer {
    0% {
        left: -100%;
    }
    100% {
        left: 100%;
    }
}

@keyframes slideUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.search-form {
    display: flex;
    gap: 1rem;
    max-width: 600px;
    margin: 0 auto;
}

.search-input-group {
    flex: 1;
    position: relative;
}

.search-input {
    width: 100%;
    height: 60px;
    background: var(--bg-card);
    border: 2px solid var(--secondary-blue);
    border-radius: var(--radius-sm);
    padding: 0 1.5rem 0 4rem;
    font-size: 1.1rem;
    color: var(--text-primary);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    font-family: inherit;
}

.search-input::placeholder {
    color: var(--text-secondary);
}

.search-input:focus {
    outline: none;
    border-color: var(--primary-blue);
    box-shadow: 0 0 0 4px rgba(0, 102, 255, 0.1);
}

.search-icon {
    position: absolute;
    left: 1.5rem;
    top: 50%;
    transform: translateY(-50%);
    width: 24px;
    height: 24px;
    stroke: var(--text-secondary);
    fill: none;
    transition: stroke 0.3s ease;
}

.search-input:focus + .search-icon {
    stroke: var(--primary-blue);
}

.search-btn {
    height: 60px;
    padding: 0 2rem;
    background: var(--gradient-primary);
    border: none;
    border-radius: var(--radius-sm);
    color: white;
    font-size: 1.1rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: var(--shadow-primary);
    position: relative;
    overflow: hidden;
}

.search-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
}

.search-btn:hover::before {
    left: 100%;
}

.search-btn:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-glow);
}

.search-btn:active {
    transform: translateY(0);
}

/* Results section */
.results-section {
    animation: fadeIn 1s ease-out 0.3s both;
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

.section-title {
    font-size: 2rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 2rem;
    text-align: center;
}

.cards-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 2rem;
    margin-top: 2rem;
}

.movie-card {
    background: var(--bg-glass);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(59, 130, 246, 0.2);
    border-radius: var(--radius);
    padding: 2rem;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    cursor: pointer;
    position: relative;
    overflow: hidden;
    animation: cardSlide 0.6s ease-out;
}

@keyframes cardSlide {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.movie-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: var(--gradient-primary);
    transform: scaleX(0);
    transition: transform 0.3s ease;
}

.movie-card:hover::before {
    transform: scaleX(1);
}

.movie-card:hover {
    transform: translateY(-8px);
    box-shadow: var(--shadow-glow);
    border-color: var(--primary-blue);
}

.card-header {
    display: flex;
    align-items: center;
    gap: 1.5rem;
    margin-bottom: 1.5rem;
}

.card-number {
    width: 48px;
    height: 48px;
    background: var(--gradient-primary);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 1.2rem;
    color: white;
    flex-shrink: 0;
}

.poster-container {
    width: 80px;
    height: 120px;
    border-radius: var(--radius-sm);
    overflow: hidden;
    position: relative;
    flex-shrink: 0;
    background: var(--bg-card);
}

.poster-img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
}

.movie-card:hover .poster-img {
    transform: scale(1.05);
}

.card-info {
    flex: 1;
    min-width: 0;
}

.movie-title {
    font-size: 1.25rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 0.5rem;
    line-height: 1.3;
}

.movie-meta {
    color: var(--text-secondary);
    font-size: 0.95rem;
    margin-bottom: 1rem;
    font-weight: 500;
}

.movie-synopsis {
    color: var(--text-secondary);
    font-size: 0.95rem;
    line-height: 1.6;
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

/* Action buttons */
.card-actions {
    margin-top: 1.5rem;
    display: flex;
    gap: 1rem;
}

.btn {
    padding: 0.75rem 1.5rem;
    border-radius: var(--radius-sm);
    font-weight: 600;
    font-size: 0.95rem;
    cursor: pointer;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border: none;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    position: relative;
    overflow: hidden;
}

.btn-primary {
    background: var(--gradient-primary);
    color: white;
    box-shadow: var(--shadow-primary);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-glow);
}

.btn-secondary {
    background: transparent;
    color: var(--primary-blue);
    border: 2px solid var(--primary-blue);
}

.btn-secondary:hover {
    background: var(--primary-blue);
    color: white;
}

/* Navigation */
.nav-container {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: var(--bg-glass);
    backdrop-filter: blur(20px);
    border-top: 1px solid rgba(59, 130, 246, 0.3);
    padding: 1.5rem 2rem;
    z-index: 1000;
}

.nav-links {
    display: flex;
    justify-content: center;
    gap: 1.5rem;
    max-width: 800px;
    margin: 0 auto;
}

/* Scroll to top button */
.scroll-top-btn {
    position: fixed;
    bottom: 120px;
    right: 24px;
    width: 56px;
    height: 56px;
    background: var(--gradient-primary);
    border: none;
    border-radius: 50%;
    color: white;
    font-size: 1.5rem;
    cursor: pointer;
    box-shadow: var(--shadow-primary);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    z-index: 1500;
    opacity: 0;
    visibility: hidden;
}

.scroll-top-btn.show {
    opacity: 1;
    visibility: visible;
}

.scroll-top-btn:hover {
    transform: translateY(-4px);
    box-shadow: var(--shadow-glow);
}

/* Loading animation */
.loading {
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 3rem;
}

.loading-spinner {
    width: 48px;
    height: 48px;
    border: 4px solid rgba(59, 130, 246, 0.3);
    border-top: 4px solid var(--primary-blue);
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% {
        transform: rotate(0deg);
    }
    100% {
        transform: rotate(360deg);
    }
}

/* Responsive design */
@media (max-width: 768px) {
    .container {
        padding: 1rem;
    }

    .search-form {
        flex-direction: column;
    }

    .search-btn {
        width: 100%;
    }

    .cards-grid {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }

    .nav-links {
        flex-direction: column;
        gap: 1rem;
    }

    .btn {
        width: 100%;
        justify-content: center;
    }

    .main-title {
        font-size: 2.5rem;
    }

    .card-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }

    .poster-container {
        align-self: center;
    }
}

@media (max-width: 480px) {
    .search-section {
        padding: 1.5rem;
    }

    .movie-card {
        padding: 1.5rem;
    }

    .toggle-theme {
        width: 48px;
        height: 48px;
        top: 16px;
        right: 16px;
    }
}

/* Error states */
.error-message {
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid rgba(239, 68, 68, 0.3);
    border-radius: var(--radius-sm);
    padding: 1.5rem;
    color: #fca5a5;
    text-align: center;
    margin: 2rem 0;
}

/* Success states */
.success-message {
    background: rgba(16, 185, 129, 0.1);
    border: 1px solid rgba(16, 185, 129, 0.3);
    border-radius: var(--radius-sm);
    padding: 1.5rem;
    color: #6ee7b7;
    text-align: center;
    margin: 2rem 0;
}

/* Modal styles */
.modal {
    display: none;
    position: fixed;
    z-index: 3000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.8);
    backdrop-filter: blur(10px);
}

.modal-content {
    background: var(--bg-glass);
    backdrop-filter: blur(20px);
    margin: 5% auto;
    padding: 2rem;
    border: 1px solid rgba(59, 130, 246, 0.3);
    border-radius: var(--radius);
    width: 90%;
    max-width: 600px;
    position: relative;
    animation: modalSlide 0.5s ease-out;
}

@keyframes modalSlide {
    from {
        opacity: 0;
        transform: translateY(-50px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.close {
    color: var(--text-secondary);
    float: right;
    font-size: 28px;
    font-weight: bold;
    cursor: pointer;
    transition: color 0.3s ease;
}

.close:hover {
    color: var(--primary-blue);
}


/* Estilos do Sidebar */
/* Estilos do Sidebar Futurista */
.sidebar {
    width: 280px;
    background: var(--bg-glass);
    backdrop-filter: blur(20px);
    padding: 2rem 1.5rem;
    box-shadow: var(--shadow-glow);
    display: flex;
    flex-direction: column;
    border-right: 1px solid rgba(59, 130, 246, 0.4);
    z-index: 100;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    min-height: 100vh;
    position: fixed;
    top: 0;
    left: 0;
    overflow-x: hidden;
    overflow-y: auto;
}

/* Sidebar minimizado */
.sidebar.minimized {
    width: 80px;
    padding: 2rem 1rem;
}

.sidebar.minimized .sidebar-text {
    opacity: 0;
    visibility: hidden;
    transform: translateX(-20px);
}

.sidebar.minimized .sidebar h2 {
    font-size: 0;
    margin-bottom: 2rem;
}

.sidebar.minimized .sidebar h2::after {
    content: 'M';
    font-size: 1.5rem;
    font-weight: 900;
    background: var(--gradient-primary);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.sidebar.minimized .logout-btn .sidebar-text {
    display: none;
}

/* Efeito de brilho animado no sidebar */
.sidebar::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(0, 102, 255, 0.1), transparent);
    animation: sidebarShimmer 3s infinite;
}

@keyframes sidebarShimmer {
    0% {
        left: -100%;
    }
    100% {
        left: 100%;
    }
}

/* Botão de toggle do sidebar */
.sidebar-toggle {
    position: absolute;
    top: 1.5rem;
    right: -20px;
    width: 40px;
    height: 40px;
    background: var(--gradient-primary);
    border: none;
    border-radius: 50%;
    color: white;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: var(--shadow-primary);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    z-index: 200;
    backdrop-filter: blur(10px);
}

.sidebar-toggle:hover {
    transform: scale(1.1);
    box-shadow: var(--shadow-glow);
}

.sidebar-toggle svg {
    width: 20px;
    height: 20px;
    transition: transform 0.3s ease;
}

.sidebar.minimized .sidebar-toggle svg {
    transform: rotate(180deg);
}

.sidebar h2 {
    font-size: 1.8rem;
    font-weight: 900;
    background: var(--gradient-primary);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    margin-bottom: 2.5rem;
    text-align: center;
    letter-spacing: -0.02em;
    position: relative;
    z-index: 10;
    animation: titlePulse 2s ease-in-out infinite alternate;
    transition: all 0.3s ease;
    overflow: hidden;
}

@keyframes titlePulse {
    from {
        filter: drop-shadow(0 0 10px rgba(0, 102, 255, 0.3));
    }
    to {
        filter: drop-shadow(0 0 20px rgba(6, 182, 212, 0.5));
    }
}

.sidebar ul {
    list-style: none;
    padding: 0;
    margin-bottom: auto;
    position: relative;
    z-index: 10;
}

.sidebar ul li {
    margin-bottom: 1rem;
    position: relative;
}

/* Estilos futuristas para os links do sidebar */
.sidebar ul li a {
    color: var(--text-primary);
    text-decoration: none;
    padding: 1rem 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    border-radius: var(--radius-sm);
    font-weight: 600;
    background: var(--bg-card);
    border: 2px solid transparent;
    box-shadow: 0 4px 15px rgba(0, 102, 255, 0.1);
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
    backdrop-filter: blur(10px);
    white-space: nowrap;
}

.sidebar ul li a .sidebar-text {
    transition: all 0.3s ease;
    opacity: 1;
    visibility: visible;
    transform: translateX(0);
}

.sidebar.minimized ul li a {
    justify-content: center;
    padding: 1rem;
}

.sidebar.minimized ul li a .sidebar-text {
    opacity: 0;
    visibility: hidden;
    transform: translateX(-20px);
    position: absolute;
}

/* Efeito de linha animada */
.sidebar ul li a::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 4px;
    height: 100%;
    background: var(--gradient-primary);
    transform: scaleY(0);
    transition: transform 0.3s ease;
    border-radius: 0 4px 4px 0;
}

.sidebar ul li a:hover::before {
    transform: scaleY(1);
}

/* Efeito de brilho nos links */
.sidebar ul li a::after {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
    transition: left 0.5s;
}

.sidebar ul li a:hover::after {
    left: 100%;
}

.sidebar ul li a:hover {
    background: rgba(59, 130, 246, 0.15);
    border-color: var(--primary-blue);
    transform: translateX(8px);
    box-shadow: 0 8px 25px rgba(0, 102, 255, 0.3);
    color: var(--cyan);
}

.sidebar ul li a:active {
    transform: translateX(4px);
}

/* Estilos para os ícones SVG */
.sidebar ul li a svg {
    width: 22px;
    height: 22px;
    stroke: currentColor;
    fill: none;
    transition: all 0.3s ease;
    filter: drop-shadow(0 0 4px rgba(0, 102, 255, 0.3));
}

.sidebar ul li a:hover svg {
    transform: scale(1.1);
    filter: drop-shadow(0 0 8px rgba(6, 182, 212, 0.6));
}

/* Estilos aprimorados para o botão Sair */
.logout-btn {
    background: linear-gradient(135deg, rgba(239, 68, 68, 0.9) 0%, rgba(220, 38, 38, 0.9) 100%);
    color: white;
    border: 2px solid rgba(239, 68, 68, 0.5);
    padding: 1rem 1.5rem;
    border-radius: var(--radius-sm);
    cursor: pointer;
    text-decoration: none;
    text-align: center;
    margin-top: 2rem;
    font-weight: 600;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 4px 20px rgba(239, 68, 68, 0.3);
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.75rem;
    backdrop-filter: blur(10px);
    position: relative;
    overflow: hidden;
    z-index: 10;
    white-space: nowrap;
}

.logout-btn .sidebar-text {
    transition: all 0.3s ease;
    opacity: 1;
    visibility: visible;
    transform: translateX(0);
}

.sidebar.minimized .logout-btn {
    padding: 1rem;
}

.sidebar.minimized .logout-btn .sidebar-text {
    opacity: 0;
    visibility: hidden;
    transform: translateX(-20px);
    position: absolute;
}

.logout-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
}

.logout-btn:hover::before {
    left: 100%;
}

.logout-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 0 30px rgba(239, 68, 68, 0.6);
    border-color: rgba(239, 68, 68, 0.8);
    background: linear-gradient(135deg, rgba(239, 68, 68, 1) 0%, rgba(220, 38, 38, 1) 100%);
}

.logout-btn:active {
    transform: translateY(-1px);
}

.logout-btn svg {
    width: 20px;
    height: 20px;
    stroke: currentColor;
    fill: none;
    transition: all 0.3s ease;
}

.logout-btn:hover svg {
    transform: rotate(10deg) scale(1.1);
}

/* Estilos para o conteúdo principal */
.content {
    flex-grow: 1;
    padding: 2.5rem;
    background: var(--bg-glass);
    backdrop-filter: blur(20px);
    margin: 1.5rem 1.5rem 1.5rem 300px; /* Margem esquerda para dar espaço ao sidebar */
    border-radius: var(--radius);
    box-shadow: var(--shadow-primary);
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    border: 1px solid rgba(59, 130, 246, 0.2);
    position: relative;
    overflow: hidden;
    min-height: calc(100vh - 3rem);
}

/* Ajuste do conteúdo quando sidebar está minimizado */
.sidebar.minimized ~ .content {
    margin-left: 100px; /* Espaço menor quando minimizado */
}

/* Layout principal */
.main-layout {
    display: flex;
    min-height: 100vh;
}

/* JavaScript para funcionalidade do toggle */
.sidebar-script {
    display: none;
}

.content::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: var(--gradient-primary);
    animation: contentShimmer 2s ease-in-out infinite alternate;
}

@keyframes contentShimmer {
    from {
        opacity: 0.5;
    }
    to {
        opacity: 1;
    }
}

.content h1 {
    font-size: 2.5rem;
    font-weight: 800;
    background: var(--gradient-primary);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    margin-bottom: 1.5rem;
    letter-spacing: -0.02em;
    filter: drop-shadow(0 2px 4px rgba(0, 102, 255, 0.2));
}

.content p {
    color: var(--text-secondary);
    line-height: 1.7;
    font-size: 1.1rem;
    margin-bottom: 1.5rem;
}

/* Estilos para mensagens aprimoradas */
.message {
    margin: 1.5rem 0;
    padding: 1.25rem 1.5rem;
    border-radius: var(--radius-sm);
    font-size: 1rem;
    font-weight: 500;
    position: relative;
    backdrop-filter: blur(10px);
    border: 2px solid transparent;
    animation: messageSlide 0.5s ease-out;
}

@keyframes messageSlide {
    from {
        opacity: 0;
        transform: translateY(-20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.message.error {
    background: rgba(239, 68, 68, 0.15);
    border-color: rgba(239, 68, 68, 0.4);
    color: #fca5a5;
    box-shadow: 0 4px 20px rgba(239, 68, 68, 0.2);
}

.message.success {
    background: rgba(16, 185, 129, 0.15);
    border-color: rgba(16, 185, 129, 0.4);
    color: #6ee7b7;
    box-shadow: 0 4px 20px rgba(16, 185, 129, 0.2);
}

/* Tema claro aprimorado */
body.light-theme .sidebar {
    background: rgba(255, 255, 255, 0.95);
    border-right-color: rgba(0, 102, 255, 0.2);
    box-shadow: 0 8px 32px rgba(0, 102, 255, 0.15);
}

body.light-theme .content {
    background: rgba(248, 250, 252, 0.95);
    box-shadow: 0 8px 32px rgba(0, 102, 255, 0.1);
    border-color: rgba(0, 102, 255, 0.1);
}

body.light-theme .sidebar ul li a {
    background: rgba(248, 250, 252, 0.8);
    border-color: transparent;
    box-shadow: 0 4px 15px rgba(0, 102, 255, 0.08);
    color: var(--text-primary);
}

body.light-theme .sidebar ul li a:hover {
    background: rgba(59, 130, 246, 0.1);
    border-color: var(--primary-blue);
    color: var(--primary-blue);
    box-shadow: 0 8px 25px rgba(0, 102, 255, 0.2);
}

/* Responsividade aprimorada */
@media (max-width: 1024px) {
    .sidebar {
        width: 250px;
        padding: 1.5rem 1rem;
    }
    
    .sidebar.minimized {
        width: 70px;
    }
    
    .content {
        margin-left: 270px;
        padding: 2rem;
    }
    
    .sidebar.minimized ~ .content {
        margin-left: 90px;
    }
}

@media (max-width: 768px) {
    .sidebar {
        width: 100%;
        min-height: auto;
        position: relative;
        border-right: none;
        border-bottom: 1px solid rgba(59, 130, 246, 0.4);
        transform: translateX(0);
    }
    
    .sidebar.minimized {
        width: 100%;
        padding: 1rem;
    }
    
    .sidebar-toggle {
        display: none;
    }
    
    .sidebar ul {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
    }
    
    .sidebar ul li {
        margin-bottom: 0;
    }
    
    .content {
        margin: 0;
        border-radius: 0;
        min-height: auto;
    }
    
    .sidebar.minimized ~ .content {
        margin-left: 0;
    }
    
    .logout-btn {
        margin-top: 1rem;
    }
    
    .main-layout {
        flex-direction: column;
    }
}

@media (max-width: 480px) {
    .sidebar {
        padding: 1rem;
    }
    
    .sidebar ul {
        grid-template-columns: 1fr;
    }
    
    .sidebar ul li a {
        padding: 0.875rem 1rem;
        font-size: 0.95rem;
    }
    
    .content {
        padding: 1.5rem;
    }
    
    .content h1 {
        font-size: 2rem;
    }
}

/* Tooltip para sidebar minimizado */
.sidebar.minimized ul li a:hover::after {
    content: attr(data-tooltip);
    position: absolute;
    left: 100%;
    top: 50%;
    transform: translateY(-50%);
    background: var(--bg-card);
    color: var(--text-primary);
    padding: 0.5rem 1rem;
    border-radius: var(--radius-sm);
    white-space: nowrap;
    margin-left: 10px;
    box-shadow: var(--shadow-primary);
    z-index: 1000;
    font-size: 0.9rem;
    border: 1px solid rgba(59, 130, 246, 0.3);
    backdrop-filter: blur(10px);
}

.sidebar.minimized .logout-btn:hover::after {
    content: "Sair";
    position: absolute;
    left: 100%;
    top: 50%;
    transform: translateY(-50%);
    background: var(--bg-card);
    color: var(--text-primary);
    padding: 0.5rem 1rem;
    border-radius: var(--radius-sm);
    white-space: nowrap;
    margin-left: 10px;
    box-shadow: var(--shadow-primary);
    z-index: 1000;
    font-size: 0.9rem;
    border: 1px solid rgba(59, 130, 246, 0.3);
    backdrop-filter: blur(10px);
}

.sidebar.minimized ul li a:hover::after {
    content: attr(data-tooltip); /* This uses the data-tooltip value */
    /* ... other tooltip styles ... */
}
    
    
  </style>
</head>
<body>
  <!-- Animated background -->
  <div class="bg-animation">
    <div class="particle"></div>
    <div class="particle"></div>
    <div class="particle"></div>
    <div class="particle"></div>
    <div class="particle"></div>
  </div>

  <!-- Theme toggle -->
  <button class="toggle-theme" aria-label="Alternar tema" onclick="toggleTheme()">
    <svg viewBox="0 0 24 24" stroke-width="2">
      <circle cx="12" cy="12" r="5"/>
      <line x1="12" y1="1" x2="12" y2="3"/>
      <line x1="12" y1="21" x2="12" y2="23"/>
      <line x1="4.22" y1="4.22" x2="5.64" y2="5.64"/>
      <line x1="18.36" y1="18.36" x2="19.78" y2="19.78"/>
      <line x1="1" y1="12" x2="3" y2="12"/>
      <line x1="21" y1="12" x2="23" y2="12"/>
      <line x1="4.22" y1="19.78" x2="5.64" y2="18.36"/>
      <line x1="18.36" y1="5.64" x2="19.78" y2="4.22"/>
    </svg>
  </button>

  <!-- Scroll to top button -->
  <button class="scroll-top-btn" id="scrollTopBtn" onclick="scrollToTop()">
    ↑
  </button>

  <div class="container">
    <!-- Header Section -->
    <header class="header-section">
      <h1 class="main-title">Gerador de Banner</h1>
      <p class="subtitle">
        Crie banners profissionais de filmes e séries com apenas alguns cliques. 
        Design moderno, responsivo e otimizado para todas as plataformas.
      </p>
    </header>

    <!-- Search Section -->
    <section class="search-section">
      <form class="search-form" id="searchForm" onsubmit="searchMovies(event)">
        <div class="search-input-group">
          <input 
            type="text" 
            class="search-input" 
            id="searchInput"
            placeholder="Digite o nome do filme ou série..." 
            required
            autocomplete="off"
          >
          <svg class="search-icon" viewBox="0 0 24 24" stroke-width="2">
            <circle cx="11" cy="11" r="8"/>
            <path d="m21 21-4.35-4.35"/>
          </svg>
        </div>
        <button type="submit" class="search-btn">
          <span>Buscar</span>
        </button>
      </form>
    </section>

    <!-- Results Section -->
    <section class="results-section">
      <div id="searchResults">
        <!-- Popular movies will be loaded here initially -->
        <h2 class="section-title">Filmes e Séries Populares</h2>
        <div class="cards-grid" id="moviesGrid">
          <!-- Sample movie cards -->
          <div class="movie-card" onclick="generateBanner(552524, 'filme')">
            <div class="card-header">
              <div class="card-number">1</div>
              <div class="poster-container">
                <img src="https://image.tmdb.org/t/p/w300/toLU4HzWf2iKqPbElKPDypKNGTr.jpg" alt="Lilo & Stitch" class="poster-img" onerror="this.src='https://via.placeholder.com/300x450/1a1f2e/94a3b8?text=Sem+Imagem'">
              </div>
              <div class="card-info">
                <h3 class="movie-title">Lilo & Stitch</h3>
                <div class="movie-meta">2025 • Família/Comédia</div>
              </div>
            </div>
            <p class="movie-synopsis">
              Uma menina havaiana solitária faz amizade com um alienígena fugitivo, 
              ajudando a remendar sua família fragmentada.
            </p>
            <div class="card-actions">
              <button class="btn btn-primary" onclick="event.stopPropagation(); generateBanner(552524, 'filme')">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                  <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                </svg>
                Gerar Banner
              </button>
            </div>
          </div>

          <div class="movie-card" onclick="generateBanner(1257960, 'filme')">
            <div class="card-header">
              <div class="card-number">2</div>
              <div class="poster-container">
                <img src="https://image.tmdb.org/t/p/w300/41s42CRXafa3OuRGvCtfYPEBmse.jpg" alt="Sikandar" class="poster-img" onerror="this.src='https://via.placeholder.com/300x450/1a1f2e/94a3b8?text=Sem+Imagem'">
              </div>
              <div class="card-info">
                <h3 class="movie-title">Sikandar</h3>
                <div class="movie-meta">2025 • Ação/Drama</div>
              </div>
            </div>
            <p class="movie-synopsis">
              Um trágico acidente leva o poderoso Sikandar a proteger os menos afortunados, 
              usando de todos os meios para enfrentar a corrupção e a ganância.
            </p>
            <div class="card-actions">
              <button class="btn btn-primary" onclick="event.stopPropagation(); generateBanner(1257960, 'filme')">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                  <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                </svg>
                Gerar Banner
              </button>
            </div>
          </div>

          <div class="movie-card" onclick="generateBanner(1233413, 'filme')">
            <div class="card-header">
              <div class="card-number">3</div>
              <div class="poster-container">
                <img src="https://image.tmdb.org/t/p/w300/a9kYEboW1TQaeilGYUAx1MO0DUp.jpg" alt="Pecadores" class="poster-img" onerror="this.src='https://via.placeholder.com/300x450/1a1f2e/94a3b8?text=Sem+Imagem'">
              </div>
              <div class="card-info">
                <h3 class="movie-title">Pecadores</h3>
                <div class="movie-meta">2025 • Terror/Ação</div>
              </div>
            </div>
            <p class="movie-synopsis">
              Dispostos a deixar suas vidas conturbadas para trás, irmãos gêmeos retornam 
              à sua cidade natal para recomeçar suas vidas do zero.
            </p>
            <div class="card-actions">
              <button class="btn btn-primary" onclick="event.stopPropagation(); generateBanner(1233413, 'filme')">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                  <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                </svg>
                Gerar Banner
              </button>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

<div class="sidebar">
    <button class="sidebar-toggle" id="sidebarToggle">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-left">
            <path d="m15 18-6-6 6-6"/>
        </svg>
    </button>
    <h2>Menu Admin</h2>
    <ul>
        <?php if ($_SESSION['user_perfil'] === 'admin'): ?>
            <li>
                <a href="criar_conta.php" data-tooltip="Criar Conta">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-user-plus">
                        <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/><circle cx="9" cy="7" r="4"/><line x1="19" x2="19" y1="8" y2="14"/><line x1="22" x2="16" y1="11" y2="11"/>
                    </svg>
                    <span class="sidebar-text">Criar Conta</span>
                </a>
            </li>
            <li>
                <a href="editar_cliente.php" data-tooltip="Editar Cliente">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-user-cog">
                        <circle cx="12" cy="12" r="3"/><path d="M19.07 4.93A10 10 0 0 0 10 2v2a8 8 0 0 1 6.83 6.83L19.07 4.93Z"/><path d="M22 12h-2a8 8 0 0 1-6.83 6.83L4.93 19.07A10 10 0 0 0 2 12h2a8 8 0 0 1 6.83-6.83L4.93 19.07Z"/><path d="m21 21-4.35-4.35"/>
                    </svg>
                    <span class="sidebar-text">Editar Cliente</span>
                </a>
            </li>
            <li>
                <a href="mudar_senha_cliente.php" data-tooltip="Mudar Senha de Cliente">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-key-round">
                        <path d="M2 18v3c0 .6.4 1 1 1h4v-3h3v-3H2Z"/><path d="M7 9a5 5 0 0 1 8 0"/><circle cx="15" cy="9" r="3"/><path d="M12 17H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h10c.8 0 1.5.4 2 1l3 3h-3a3 3 0 0 0-3 3Z"/>
                    </svg>
                    <span class="sidebar-text">Mudar Senha de Cliente</span>
                </a>
            </li>
            <li>
                <a href="gerenciar_banners.php" data-tooltip="Gerenciar Banners">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-layout-panel-left">
                        <rect x="3" y="3" width="18" height="18" rx="2"/><path d="M10 3v18"/>
                    </svg>
                    <span class="sidebar-text">Gerenciar Banners</span>
                </a>
            </li>
        <?php endif; ?>
        <li>
            <a href="meus_dados.php" data-tooltip="Meus Dados">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-user">
                    <circle cx="12" cy="7" r="4"/><path d="M12 20v-2c-2.2 0-4-1.8-4-4s1.8-4 4-4 4 1.8 4 4-1.8 4-4 4Z"/>
                </svg>
                <span class="sidebar-text">Meus Dados</span>
            </a>
        </li>
        <li>
            <a href="meus_banners.php" data-tooltip="Meus Banners">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-image">
                    <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><circle cx="9" cy="9" r="2"/><path d="m21 15-3.5-3.5L14 17l-4.5-4.5L3 17"/>
                </svg>
                <span class="sidebar-text">Meus Banners</span>
            </a>
        </li>
    </ul>
    <a href="logout.php" class="logout-btn">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-log-out">
            <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/><polyline points="16 17 21 12 16 7"/><line x1="21" x2="9" y1="12" y2="12"/>
        </svg>
        <span class="sidebar-text">Sair</span>
    </a>
</div>

  <!-- Modal for banner preview -->
  <div id="bannerModal" class="modal">
    <div class="modal-content">
      <span class="close" onclick="closeBannerModal()">&times;</span>
      <h2>Banner Gerado</h2>
      <div id="bannerPreview"></div>
      <div style="margin-top: 1rem; text-align: center;">
        <button class="btn btn-primary" onclick="downloadBanner()">
          <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
            <path
            <!-- Modal for banner preview -->
<div id="bannerModal" class="modal">
  <div class="modal-content">
    <span class="close" onclick="closeBannerModal()">&times;</span>
    <h2>Banner Gerado</h2>
    <div id="bannerPreview"></div>
    <div style="margin-top: 1rem; text-align: center;">
      <button class="btn btn-primary" onclick="downloadBanner()">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
          <path d="M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z"/>
        </svg>
        Baixar Banner
      </button>
    </div>
  </div>
</div>

<script>


    document.addEventListener('DOMContentLoaded', () => {
        const sidebar = document.querySelector('.sidebar');
        const sidebarToggle = document.getElementById('sidebarToggle');
        const body = document.body; // To adjust body/content margin

        if (sidebarToggle && sidebar) {
            sidebarToggle.addEventListener('click', () => {
                // Toggles the 'minimized' class on the sidebar
                sidebar.classList.toggle('minimized');

                // Toggles a class on the body. This is useful if your main
                // content's margin needs to change directly based on the body class,
                // or if you have other layout elements that react to sidebar state.
                body.classList.toggle('sidebar-is-minimized'); // Using a different class name for clarity
            });
        }
    });



  // Tema
  function toggleTheme() {
    document.body.classList.toggle('light-theme');
  }

  // Scroll to top
  function scrollToTop() {
    window.scrollTo({ top: 0, behavior: 'smooth' });
  }

  // Mostra/esconde botão de scroll
  window.addEventListener('scroll', function() {
    const scrollTopBtn = document.getElementById('scrollTopBtn');
    if (window.scrollY > 300) {
      scrollTopBtn.classList.add('show');
    } else {
      scrollTopBtn.classList.remove('show');
    }
  });

  // Função para buscar filmes/séries
  async function searchMovies(event) {
    event.preventDefault();
    const query = document.getElementById('searchInput').value;
    
    try {
      const response = await fetch(`fetch_tmdb_search.php?query=${encodeURIComponent(query)}`);
      const data = await response.json();
      
      // Renderizar resultados
      renderSearchResults(data.results);
    } catch (error) {
      console.error('Erro na busca:', error);
      showErrorMessage('Erro ao buscar filmes/séries');
    }
  }

  // Função para renderizar resultados
  function renderSearchResults(results) {
    const resultsContainer = document.getElementById('searchResults');
    const moviesGrid = document.getElementById('moviesGrid');
    
    // Limpar resultados anteriores
    moviesGrid.innerHTML = '';
    
    // Título
    const titleEl = document.createElement('h2');
    titleEl.classList.add('section-title');
    titleEl.textContent = results.length ? 'Resultados da Busca' : 'Nenhum resultado encontrado';
    resultsContainer.prepend(titleEl);
    
    // Renderizar cards
    results.forEach((movie, index) => {
      if (movie.media_type === 'movie' || movie.media_type === 'tv') {
        const card = createMovieCard(movie, index + 1);
        moviesGrid.appendChild(card);
      }
    });
  }

  // Função para criar card de filme/série
  function createMovieCard(movie, rank) {
    const card = document.createElement('div');
    card.classList.add('movie-card');
    
    const title = movie.title || movie.name;
    const posterPath = movie.poster_path 
      ? `https://image.tmdb.org/t/p/w300${movie.poster_path}`
      : 'https://via.placeholder.com/300x450/1a1f2e/94a3b8?text=Sem+Imagem';
    
    card.innerHTML = `
      <div class="card-header">
        <div class="card-number">${rank}</div>
        <div class="poster-container">
          <img src="${posterPath}" alt="${title}" class="poster-img" 
               onerror="this.src='https://via.placeholder.com/300x450/1a1f2e/94a3b8?text=Sem+Imagem'">
        </div>
        <div class="card-info">
          <h3 class="movie-title">${title}</h3>
          <div class="movie-meta">
            ${movie.release_date ? movie.release_date.split('-')[0] : 'Ano desconhecido'} 
            • ${movie.media_type === 'movie' ? 'Filme' : 'Série'}
          </div>
        </div>
      </div>
      <p class="movie-synopsis">
        ${movie.overview || 'Sinopse não disponível.'}
      </p>
      <div class="card-actions">
        <button class="btn btn-primary" onclick="generateBanner(${movie.id}, '${movie.media_type}')">
          <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
            <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
          </svg>
          Gerar Banner
        </button>
      </div>
    `;
    
    return card;
  }

Copiar

function generateBanner(id, type) {
    // Redirecionar para a página gerar_banner.php com os parâmetros
    window.location.href = `gerar_banner.php?id=${id}&type=${type}`;
}

  // Fechar modal
  function closeBannerModal() {
    const modal = document.getElementById('bannerModal');
    modal.style.display = 'none';
  }

  // Baixar banner
  function downloadBanner() {
    const bannerPreview = document.getElementById('bannerPreview');
    if (bannerPreview.innerHTML.trim() === '') {
      showErrorMessage('Nenhum banner para download');
      return;
    }

    // Implementar lógica de download
    fetch('download_banner.php', {
      method: 'POST',
      body: JSON.stringify({ bannerHtml: bannerPreview.innerHTML })
    })
    .then(response => response.blob())
    .then(blob => {
      const link = document.createElement('a');
      link.href = URL.createObjectURL(blob);
      link.download = 'banner.png';
      link.click();
    })
    .catch(error => {
      console.error('Erro no download:', error);
      showErrorMessage('Erro no download do banner');
    });
  }

  // Função para mostrar mensagem de erro
  function showErrorMessage(message) {
    const errorDiv = document.createElement('div');
    errorDiv.classList.add('error-message');
    errorDiv.textContent = message;
    
    const container = document.querySelector('.container');
    container.insertBefore(errorDiv, container.firstChild);
    
    // Remover após 5 segundos
    setTimeout(() => {
      errorDiv.remove();
    }, 5000);
  }
</script>
</body>
</html>
