<?php
session_start(); // Inicia a sessão

// Configurações do banco de dados
$host = 'localhost'; // Ou o IP do seu banco de dados
$db = 'infroshop_banner'; // Nome do seu banco de dados
$user = 'infroshop_user'; // Seu usuário do banco de dados
$pass = 'edlKU2y3bO?d'; // Sua senha do banco de dados
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    // Redireciona com mensagem de erro se a conexão falhar
    header('Location: login.html?message=' . urlencode('Erro de conexão com o banco de dados. Por favor, tente novamente mais tarde.') . '&type=error');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $senha = $_POST['senha'] ?? '';

    // Validação básica de entrada
    if (empty($email) || empty($senha)) {
        header('Location: login.html?message=' . urlencode('Por favor, preencha todos os campos.') . '&type=error');
        exit();
    }

    // Prepara e executa a consulta SQL para buscar o usuário,
    // incluindo a coluna 'perfil' (ou 'role')
    // É crucial que você tenha uma coluna 'perfil' na sua tabela 'usuarios'
    $stmt = $pdo->prepare('SELECT id, nome, email, senha, perfil FROM usuarios WHERE email = :email');
    $stmt->execute(['email' => $email]);
    $usuario = $stmt->fetch();

    if ($usuario && password_verify($senha, $usuario['senha'])) {
        // Login bem-sucedido
        $_SESSION['loggedin'] = true;
        $_SESSION['user_id'] = $usuario['id'];
        $_SESSION['user_name'] = $usuario['nome'];
        $_SESSION['user_email'] = $usuario['email'];
        $_SESSION['user_perfil'] = $usuario['perfil']; // <--- ADICIONAMOS ESTA LINHA!

        // Redireciona para a página principal (dashboard.php)
        header('Location: dashboard.php');
        exit();
    } else {
        // Credenciais inválidas
        header('Location: login.html?message=' . urlencode('E-mail ou senha inválidos.') . '&type=error');
        exit();
    }
} else {
    // Se a requisição não for POST, redireciona para o login
    header('Location: login.html');
    exit();
}